"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    insight_id: str,
    start_time_range: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of the anomalies that belong to an insight that you specify using its ID.

    Args:
        insight_id(str):  The ID of the insight. The returned anomalies belong to this insight. .
        start_time_range(Dict, optional):  A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.anomaly.for_insight.list(ctx, insight_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.anomaly.for_insight.list insight_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="list_anomalies_for_insight",
        op_kwargs={
            "InsightId": insight_id,
            "StartTimeRange": start_time_range,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
