"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, from_time: str, to_time: str = None) -> Dict:
    r"""
    **Autogenerated function**

     For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.

    Args:
        from_time(str):  The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. .
        to_time(str, optional):  The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.account.overview.describe(ctx, from_time=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.account.overview.describe from_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="describe_account_overview",
        op_kwargs={"FromTime": from_time, "ToTime": to_time},
    )
