"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

     Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your AWS account. Use these numbers to gauge the health of operations in your AWS account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.account.health.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.account.health.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="describe_account_health",
        op_kwargs={},
    )
