"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    vpce_configuration_name: str,
    vpce_service_name: str,
    service_dns_name: str,
    vpce_configuration_description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud (VPC) endpoint.

    Args:
        vpce_configuration_name(str): The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.
        vpce_service_name(str): The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.
        service_dns_name(str): The DNS name of the service running in your VPC that you want Device Farm to test.
        vpce_configuration_description(str, optional): An optional description that provides details about your VPC endpoint configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.vpce_configuration.create(
                ctx, vpce_configuration_name=value, vpce_service_name=value, service_dns_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.vpce_configuration.create vpce_configuration_name=value, vpce_service_name=value, service_dns_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="create_vpce_configuration",
        op_kwargs={
            "vpceConfigurationName": vpce_configuration_name,
            "vpceServiceName": vpce_service_name,
            "serviceDnsName": service_dns_name,
            "vpceConfigurationDescription": vpce_configuration_description,
        },
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.vpce_configuration.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.vpce_configuration.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="delete_vpce_configuration",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the configuration settings for your Amazon Virtual Private Cloud (VPC) endpoint.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.vpce_configuration.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.vpce_configuration.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="get_vpce_configuration",
        op_kwargs={"arn": arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all Amazon Virtual Private Cloud (VPC) endpoint configurations in the AWS account.

    Args:
        max_results(int, optional): An integer that specifies the maximum number of items you want to return in the API response. Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.vpce_configuration.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.vpce_configuration.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_vpce_configurations",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    arn: str,
    vpce_configuration_name: str = None,
    vpce_service_name: str = None,
    service_dns_name: str = None,
    vpce_configuration_description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates information about an Amazon Virtual Private Cloud (VPC) endpoint configuration.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to update.
        vpce_configuration_name(str, optional): The friendly name you give to your VPC endpoint configuration to manage your configurations more easily. Defaults to None.
        vpce_service_name(str, optional): The name of the VPC endpoint service running in your AWS account that you want Device Farm to test. Defaults to None.
        service_dns_name(str, optional): The DNS (domain) name used to connect to your private service in your VPC. The DNS name must not already be in use on the internet. Defaults to None.
        vpce_configuration_description(str, optional): An optional description that provides details about your VPC endpoint configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.vpce_configuration.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.vpce_configuration.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="update_vpce_configuration",
        op_kwargs={
            "arn": arn,
            "vpceConfigurationName": vpce_configuration_name,
            "vpceServiceName": vpce_service_name,
            "serviceDnsName": service_dns_name,
            "vpceConfigurationDescription": vpce_configuration_description,
        },
    )
