"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, project_arn: str, name: str, type_: str, content_type: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Uploads an app or test scripts.

    Args:
        project_arn(str): The ARN of the project for the upload.
        name(str): The upload's file name. The name should not contain any forward slashes (/). If you are uploading an iOS app, the file name must end with the .ipa extension. If you are uploading an Android app, the file name must end with the .apk extension. For all others, the file name must end with the .zip file extension.
        type_(str): The upload's upload type. Must be one of the following values:   ANDROID_APP   IOS_APP   WEB_APP   EXTERNAL_DATA   APPIUM_JAVA_JUNIT_TEST_PACKAGE   APPIUM_JAVA_TESTNG_TEST_PACKAGE   APPIUM_PYTHON_TEST_PACKAGE   APPIUM_NODE_TEST_PACKAGE   APPIUM_RUBY_TEST_PACKAGE   APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE   APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE   APPIUM_WEB_PYTHON_TEST_PACKAGE   APPIUM_WEB_NODE_TEST_PACKAGE   APPIUM_WEB_RUBY_TEST_PACKAGE   CALABASH_TEST_PACKAGE   INSTRUMENTATION_TEST_PACKAGE   UIAUTOMATION_TEST_PACKAGE   UIAUTOMATOR_TEST_PACKAGE   XCTEST_TEST_PACKAGE   XCTEST_UI_TEST_PACKAGE   APPIUM_JAVA_JUNIT_TEST_SPEC   APPIUM_JAVA_TESTNG_TEST_SPEC   APPIUM_PYTHON_TEST_SPEC   APPIUM_NODE_TEST_SPEC   APPIUM_RUBY_TEST_SPEC   APPIUM_WEB_JAVA_JUNIT_TEST_SPEC   APPIUM_WEB_JAVA_TESTNG_TEST_SPEC   APPIUM_WEB_PYTHON_TEST_SPEC   APPIUM_WEB_NODE_TEST_SPEC   APPIUM_WEB_RUBY_TEST_SPEC   INSTRUMENTATION_TEST_SPEC   XCTEST_UI_TEST_SPEC    If you call CreateUpload with WEB_APP specified, AWS Device Farm throws an ArgumentException error.
        content_type(str, optional): The upload's content type (for example, application/octet-stream). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.upload.create(
                ctx, project_arn=value, name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.upload.create project_arn=value, name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="create_upload",
        op_kwargs={
            "projectArn": project_arn,
            "name": name,
            "type": type_,
            "contentType": content_type,
        },
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an upload given the upload ARN.

    Args:
        arn(str): Represents the Amazon Resource Name (ARN) of the Device Farm upload to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.upload.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.upload.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="delete_upload",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about an upload.

    Args:
        arn(str): The upload's ARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.upload.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.upload.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="devicefarm", operation="get_upload", op_kwargs={"arn": arn}
    )


async def list_all(
    hub, ctx, arn: str, type_: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about uploads, given an AWS Device Farm project ARN.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the project for which you want to list uploads.
        type_(str, optional): The type of upload. Must be one of the following values:   ANDROID_APP   IOS_APP   WEB_APP   EXTERNAL_DATA   APPIUM_JAVA_JUNIT_TEST_PACKAGE   APPIUM_JAVA_TESTNG_TEST_PACKAGE   APPIUM_PYTHON_TEST_PACKAGE   APPIUM_NODE_TEST_PACKAGE   APPIUM_RUBY_TEST_PACKAGE   APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE   APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE   APPIUM_WEB_PYTHON_TEST_PACKAGE   APPIUM_WEB_NODE_TEST_PACKAGE   APPIUM_WEB_RUBY_TEST_PACKAGE   CALABASH_TEST_PACKAGE   INSTRUMENTATION_TEST_PACKAGE   UIAUTOMATION_TEST_PACKAGE   UIAUTOMATOR_TEST_PACKAGE   XCTEST_TEST_PACKAGE   XCTEST_UI_TEST_PACKAGE   APPIUM_JAVA_JUNIT_TEST_SPEC   APPIUM_JAVA_TESTNG_TEST_SPEC   APPIUM_PYTHON_TEST_SPEC   APPIUM_NODE_TEST_SPEC    APPIUM_RUBY_TEST_SPEC   APPIUM_WEB_JAVA_JUNIT_TEST_SPEC   APPIUM_WEB_JAVA_TESTNG_TEST_SPEC   APPIUM_WEB_PYTHON_TEST_SPEC   APPIUM_WEB_NODE_TEST_SPEC   APPIUM_WEB_RUBY_TEST_SPEC   INSTRUMENTATION_TEST_SPEC   XCTEST_UI_TEST_SPEC  . Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.upload.list_all(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.upload.list_all arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_uploads",
        op_kwargs={"arn": arn, "type": type_, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    arn: str,
    name: str = None,
    content_type: str = None,
    edit_content: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an uploaded test spec.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the uploaded test spec.
        name(str, optional): The upload's test spec file name. The name must not contain any forward slashes (/). The test spec file name must end with the .yaml or .yml file extension. Defaults to None.
        content_type(str, optional): The upload's content type (for example, application/x-yaml). Defaults to None.
        edit_content(bool, optional): Set to true if the YAML file has changed and must be updated. Otherwise, set to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.upload.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.upload.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="update_upload",
        op_kwargs={
            "arn": arn,
            "name": name,
            "contentType": content_type,
            "editContent": edit_content,
        },
    )
