"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def install(hub, ctx, remote_access_session_arn: str, app_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Installs an application to the device in a remote access session. For Android applications, the file must be in .apk format. For iOS applications, the file must be in .ipa format.

    Args:
        remote_access_session_arn(str): The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.
        app_arn(str): The ARN of the app about which you are requesting information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.to_remote_access_session.install(
                ctx, remote_access_session_arn=value, app_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.to_remote_access_session.install remote_access_session_arn=value, app_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="install_to_remote_access_session",
        op_kwargs={
            "remoteAccessSessionArn": remote_access_session_arn,
            "appArn": app_arn,
        },
    )
