"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a test.

    Args:
        arn(str): The test's ARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.init.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.init.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="devicefarm", operation="get_test", op_kwargs={"arn": arn}
    )


async def list_all(hub, ctx, arn: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about tests in a given test suite.

    Args:
        arn(str): The test suite's Amazon Resource Name (ARN).
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.init.list_all(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.init.list_all arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_tests",
        op_kwargs={"arn": arn, "nextToken": next_token},
    )
