"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, project_arn: str, expires_in_seconds: int) -> Dict:
    r"""
    **Autogenerated function**

    Creates a signed, short-term URL that can be passed to a Selenium RemoteWebDriver constructor.

    Args:
        project_arn(str): ARN (from CreateTestGridProject or ListTestGridProjects) to associate with the short-term URL. .
        expires_in_seconds(int): Lifetime, in seconds, of the URL.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.url.create(
                ctx, project_arn=value, expires_in_seconds=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.url.create project_arn=value, expires_in_seconds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="create_test_grid_url",
        op_kwargs={"projectArn": project_arn, "expiresInSeconds": expires_in_seconds},
    )
