"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, project_arn: str = None, session_id: str = None, session_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    A session is an instance of a browser created through a RemoteWebDriver with the URL from CreateTestGridUrlResult$url. You can use the following to look up sessions:   The session ARN (GetTestGridSessionRequest$sessionArn).   The project ARN and a session ID (GetTestGridSessionRequest$projectArn and GetTestGridSessionRequest$sessionId).

    Args:
        project_arn(str, optional): The ARN for the project that this session belongs to. See CreateTestGridProject and ListTestGridProjects. Defaults to None.
        session_id(str, optional): An ID associated with this session. Defaults to None.
        session_arn(str, optional): An ARN that uniquely identifies a TestGridSession. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.session.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.session.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="get_test_grid_session",
        op_kwargs={
            "projectArn": project_arn,
            "sessionId": session_id,
            "sessionArn": session_arn,
        },
    )


async def list_all(
    hub,
    ctx,
    project_arn: str,
    status: str = None,
    creation_time_after: str = None,
    creation_time_before: str = None,
    end_time_after: str = None,
    end_time_before: str = None,
    max_result: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of sessions for a TestGridProject.

    Args:
        project_arn(str): ARN of a TestGridProject.
        status(str, optional): Return only sessions in this state. Defaults to None.
        creation_time_after(str, optional): Return only sessions created after this time. Defaults to None.
        creation_time_before(str, optional): Return only sessions created before this time. Defaults to None.
        end_time_after(str, optional): Return only sessions that ended after this time. Defaults to None.
        end_time_before(str, optional): Return only sessions that ended before this time. Defaults to None.
        max_result(int, optional): Return only this many results at a time. Defaults to None.
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.session.init.list_all(
                ctx, project_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.session.init.list_all project_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_test_grid_sessions",
        op_kwargs={
            "projectArn": project_arn,
            "status": status,
            "creationTimeAfter": creation_time_after,
            "creationTimeBefore": creation_time_before,
            "endTimeAfter": end_time_after,
            "endTimeBefore": end_time_before,
            "maxResult": max_result,
            "nextToken": next_token,
        },
    )
