"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    session_arn: str,
    type_: str = None,
    max_result: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of artifacts created during the session.

    Args:
        session_arn(str): The ARN of a TestGridSession. .
        type_(str, optional): Limit results to a specified type of artifact. Defaults to None.
        max_result(int, optional): The maximum number of results to be returned by a request. Defaults to None.
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.session.artifact.list_all(
                ctx, session_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.session.artifact.list_all session_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_test_grid_session_artifacts",
        op_kwargs={
            "sessionArn": session_arn,
            "type": type_,
            "maxResult": max_result,
            "nextToken": next_token,
        },
    )
