"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, session_arn: str, max_result: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the actions taken in a TestGridSession.

    Args:
        session_arn(str): The ARN of the session to retrieve.
        max_result(int, optional): The maximum number of sessions to return per response. Defaults to None.
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.session.action.list_all(
                ctx, session_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.session.action.list_all session_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_test_grid_session_actions",
        op_kwargs={
            "sessionArn": session_arn,
            "maxResult": max_result,
            "nextToken": next_token,
        },
    )
