"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, name: str, description: str = None, vpc_config: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Selenium testing project. Projects are used to track TestGridSession instances.

    Args:
        name(str): Human-readable name of the Selenium testing project.
        description(str, optional): Human-readable description of the project. Defaults to None.
        vpc_config(Dict, optional): The VPC security groups and subnets that are attached to a project. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.project.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.project.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="create_test_grid_project",
        op_kwargs={"name": name, "description": description, "vpcConfig": vpc_config},
    )


async def delete(hub, ctx, project_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a Selenium testing project and all content generated under it.   You cannot undo this operation.   You cannot delete a project if it has active sessions.

    Args:
        project_arn(str): The ARN of the project to delete, from CreateTestGridProject or ListTestGridProjects.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.project.delete(ctx, project_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.project.delete project_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="delete_test_grid_project",
        op_kwargs={"projectArn": project_arn},
    )


async def get(hub, ctx, project_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a Selenium testing project.

    Args:
        project_arn(str): The ARN of the Selenium testing project, from either CreateTestGridProject or ListTestGridProjects.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.project.get(ctx, project_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.project.get project_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="get_test_grid_project",
        op_kwargs={"projectArn": project_arn},
    )


async def list_all(hub, ctx, max_result: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of all Selenium testing projects in your account.

    Args:
        max_result(int, optional): Return no more than this number of results. Defaults to None.
        next_token(str, optional): From a response, used to continue a paginated listing. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.project.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.project.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_test_grid_projects",
        op_kwargs={"maxResult": max_result, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    project_arn: str,
    name: str = None,
    description: str = None,
    vpc_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Change details of a project.

    Args:
        project_arn(str): ARN of the project to update.
        name(str, optional): Human-readable name for the project. Defaults to None.
        description(str, optional): Human-readable description for the project. Defaults to None.
        vpc_config(Dict, optional): The VPC security groups and subnets that are attached to a project. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.test.grid.project.update(ctx, project_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.test.grid.project.update project_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="update_test_grid_project",
        op_kwargs={
            "projectArn": project_arn,
            "name": name,
            "description": description,
            "vpcConfig": vpc_config,
        },
    )
