"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, arn: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about samples, given an AWS Device Farm job ARN.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the job used to list samples.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.sample.list_all(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.sample.list_all arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_samples",
        op_kwargs={"arn": arn, "nextToken": next_token},
    )
