"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the run, given the run ARN.  Deleting this resource does not stop an in-progress run.

    Args:
        arn(str): The Amazon Resource Name (ARN) for the run to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.run.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.run.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="devicefarm", operation="delete_run", op_kwargs={"arn": arn}
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a run.

    Args:
        arn(str): The run's ARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.run.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.run.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="devicefarm", operation="get_run", op_kwargs={"arn": arn}
    )


async def schedule(
    hub,
    ctx,
    project_arn: str,
    test: Dict,
    app_arn: str = None,
    device_pool_arn: str = None,
    device_selection_configuration: Dict = None,
    name: str = None,
    configuration: Dict = None,
    execution_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Schedules a run.

    Args:
        project_arn(str): The ARN of the project for the run to be scheduled.
        app_arn(str, optional): The ARN of an application package to run tests against, created with CreateUpload. See ListUploads. Defaults to None.
        device_pool_arn(str, optional): The ARN of the device pool for the run to be scheduled. Defaults to None.
        device_selection_configuration(Dict, optional): The filter criteria used to dynamically select a set of devices for a test run and the maximum number of devices to be included in the run. Either  devicePoolArn  or  deviceSelectionConfiguration  is required in a request. Defaults to None.
        name(str, optional): The name for the run to be scheduled. Defaults to None.
        test(Dict): Information about the test for the run to be scheduled.
        configuration(Dict, optional): Information about the settings for the run to be scheduled. Defaults to None.
        execution_configuration(Dict, optional): Specifies configuration information about a test run, such as the execution timeout (in minutes). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.run.schedule(ctx, project_arn=value, test=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.run.schedule project_arn=value, test=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="schedule_run",
        op_kwargs={
            "projectArn": project_arn,
            "appArn": app_arn,
            "devicePoolArn": device_pool_arn,
            "deviceSelectionConfiguration": device_selection_configuration,
            "name": name,
            "test": test,
            "configuration": configuration,
            "executionConfiguration": execution_configuration,
        },
    )


async def stop(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Initiates a stop request for the current test run. AWS Device Farm immediately stops the run on devices where tests have not started. You are not billed for these devices. On devices where tests have started executing, setup suite and teardown suite tests run to completion on those devices. You are billed for setup, teardown, and any tests that were in progress or already completed.

    Args:
        arn(str): Represents the Amazon Resource Name (ARN) of the Device Farm run to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.run.stop(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.run.stop arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="devicefarm", operation="stop_run", op_kwargs={"arn": arn}
    )
