"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    project_arn: str,
    device_arn: str,
    instance_arn: str = None,
    ssh_public_key: str = None,
    remote_debug_enabled: bool = None,
    remote_record_enabled: bool = None,
    remote_record_app_arn: str = None,
    name: str = None,
    client_id: str = None,
    configuration: Dict = None,
    interaction_mode: str = None,
    skip_app_resign: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Specifies and starts a remote access session.

    Args:
        project_arn(str): The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
        device_arn(str): The ARN of the device for which you want to create a remote access session.
        instance_arn(str, optional): The Amazon Resource Name (ARN) of the device instance for which you want to create a remote access session. Defaults to None.
        ssh_public_key(str, optional): Ignored. The public key of the ssh key pair you want to use for connecting to remote devices in your remote debugging session. This key is required only if remoteDebugEnabled is set to true. Remote debugging is no longer supported. Defaults to None.
        remote_debug_enabled(bool, optional): Set to true if you want to access devices remotely for debugging in your remote access session. Remote debugging is no longer supported. Defaults to None.
        remote_record_enabled(bool, optional): Set to true to enable remote recording for the remote access session. Defaults to None.
        remote_record_app_arn(str, optional): The Amazon Resource Name (ARN) for the app to be recorded in the remote access session. Defaults to None.
        name(str, optional): The name of the remote access session to create. Defaults to None.
        client_id(str, optional): Unique identifier for the client. If you want access to multiple devices on the same client, you should pass the same clientId value in each call to CreateRemoteAccessSession. This identifier is required only if remoteDebugEnabled is set to true. Remote debugging is no longer supported. Defaults to None.
        configuration(Dict, optional): The configuration information for the remote access session request. Defaults to None.
        interaction_mode(str, optional): The interaction mode of the remote access session. Valid values are:   INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot run XCUITest framework-based tests in this mode.   NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the fastest test execution speed. You can run XCUITest framework-based tests in this mode.   VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based tests and watch the screen in this mode.  . Defaults to None.
        skip_app_resign(bool, optional): When set to true, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again. For more information on how Device Farm modifies your uploads during tests, see Do you modify my app? . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.remote_access_session.create(
                ctx, project_arn=value, device_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.remote_access_session.create project_arn=value, device_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="create_remote_access_session",
        op_kwargs={
            "projectArn": project_arn,
            "deviceArn": device_arn,
            "instanceArn": instance_arn,
            "sshPublicKey": ssh_public_key,
            "remoteDebugEnabled": remote_debug_enabled,
            "remoteRecordEnabled": remote_record_enabled,
            "remoteRecordAppArn": remote_record_app_arn,
            "name": name,
            "clientId": client_id,
            "configuration": configuration,
            "interactionMode": interaction_mode,
            "skipAppResign": skip_app_resign,
        },
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a completed remote access session and its results.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the session for which you want to delete remote access.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.remote_access_session.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.remote_access_session.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="delete_remote_access_session",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a link to a currently running remote access session.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the remote access session about which you want to get session information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.remote_access_session.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.remote_access_session.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="get_remote_access_session",
        op_kwargs={"arn": arn},
    )


async def list_all(hub, ctx, arn: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all currently running remote access sessions.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the project about which you are requesting information.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.remote_access_session.list_all(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.remote_access_session.list_all arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_remote_access_sessions",
        op_kwargs={"arn": arn, "nextToken": next_token},
    )


async def stop(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Ends a specified remote access session.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the remote access session to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.remote_access_session.stop(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.remote_access_session.stop arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="stop_remote_access_session",
        op_kwargs={"arn": arn},
    )
