"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, default_job_timeout_minutes: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a project.

    Args:
        name(str): The project's name.
        default_job_timeout_minutes(int, optional): Sets the execution timeout value (in minutes) for a project. All test runs in this project use the specified execution timeout value unless overridden when scheduling a run. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.project.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.project.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="create_project",
        op_kwargs={
            "name": name,
            "defaultJobTimeoutMinutes": default_job_timeout_minutes,
        },
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an AWS Device Farm project, given the project ARN.  Deleting this resource does not stop an in-progress run.

    Args:
        arn(str): Represents the Amazon Resource Name (ARN) of the Device Farm project to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.project.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.project.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="delete_project",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a project.

    Args:
        arn(str): The project's ARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.project.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.project.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="devicefarm", operation="get_project", op_kwargs={"arn": arn}
    )


async def list_all(hub, ctx, arn: str = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about projects.

    Args:
        arn(str, optional): Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device Farm returns a list of all projects for the AWS account. You can also specify a project ARN. Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.project.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.project.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_projects",
        op_kwargs={"arn": arn, "nextToken": next_token},
    )


async def update(
    hub, ctx, arn: str, name: str = None, default_job_timeout_minutes: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified project name, given the project ARN and a new name.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the project whose name to update.
        name(str, optional): A string that represents the new name of the project that you are updating. Defaults to None.
        default_job_timeout_minutes(int, optional): The number of minutes a test run in the project executes before it times out. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.project.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.project.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="update_project",
        op_kwargs={
            "arn": arn,
            "name": name,
            "defaultJobTimeoutMinutes": default_job_timeout_minutes,
        },
    )
