"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a NotEligible error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact aws-devicefarm-support@amazon.com.

    Args:
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.offering.transaction.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.offering.transaction.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_offering_transactions",
        op_kwargs={"nextToken": next_token},
    )
