"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of products or offerings that the user can manage through the API. Each offering record indicates the recurring price per unit and the frequency for that offering. The API returns a NotEligible error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact aws-devicefarm-support@amazon.com.

    Args:
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.offering.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.offering.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_offerings",
        op_kwargs={"nextToken": next_token},
    )


async def purchase(
    hub, ctx, offering_id: str, quantity: int, offering_promotion_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for an offering, unless the renewal was overridden. The API returns a NotEligible error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact aws-devicefarm-support@amazon.com.

    Args:
        offering_id(str): The ID of the offering.
        quantity(int): The number of device slots to purchase in an offering request.
        offering_promotion_id(str, optional): The ID of the offering promotion to be applied to the purchase. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.offering.init.purchase(
                ctx, offering_id=value, quantity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.offering.init.purchase offering_id=value, quantity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="purchase_offering",
        op_kwargs={
            "offeringId": offering_id,
            "quantity": quantity,
            "offeringPromotionId": offering_promotion_id,
        },
    )


async def renew(hub, ctx, offering_id: str, quantity: int) -> Dict:
    r"""
    **Autogenerated function**

    Explicitly sets the quantity of devices to renew for an offering, starting from the effectiveDate of the next period. The API returns a NotEligible error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact aws-devicefarm-support@amazon.com.

    Args:
        offering_id(str): The ID of a request to renew an offering.
        quantity(int): The quantity requested in an offering renewal.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.offering.init.renew(
                ctx, offering_id=value, quantity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.offering.init.renew offering_id=value, quantity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="renew_offering",
        op_kwargs={"offeringId": offering_id, "quantity": quantity},
    )
