"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    project_arn: str,
    name: str,
    description: str = None,
    type_: str = None,
    uplink_bandwidth_bits: int = None,
    downlink_bandwidth_bits: int = None,
    uplink_delay_ms: int = None,
    downlink_delay_ms: int = None,
    uplink_jitter_ms: int = None,
    downlink_jitter_ms: int = None,
    uplink_loss_percent: int = None,
    downlink_loss_percent: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a network profile.

    Args:
        project_arn(str): The Amazon Resource Name (ARN) of the project for which you want to create a network profile.
        name(str): The name for the new network profile.
        description(str, optional): The description of the network profile. Defaults to None.
        type_(str, optional): The type of network profile to create. Valid values are listed here. Defaults to None.
        uplink_bandwidth_bits(int, optional): The data throughput rate in bits per second, as an integer from 0 to 104857600. Defaults to None.
        downlink_bandwidth_bits(int, optional): The data throughput rate in bits per second, as an integer from 0 to 104857600. Defaults to None.
        uplink_delay_ms(int, optional): Delay time for all packets to destination in milliseconds as an integer from 0 to 2000. Defaults to None.
        downlink_delay_ms(int, optional): Delay time for all packets to destination in milliseconds as an integer from 0 to 2000. Defaults to None.
        uplink_jitter_ms(int, optional): Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000. Defaults to None.
        downlink_jitter_ms(int, optional): Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000. Defaults to None.
        uplink_loss_percent(int, optional): Proportion of transmitted packets that fail to arrive from 0 to 100 percent. Defaults to None.
        downlink_loss_percent(int, optional): Proportion of received packets that fail to arrive from 0 to 100 percent. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.network_profile.create(
                ctx, project_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.network_profile.create project_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="create_network_profile",
        op_kwargs={
            "projectArn": project_arn,
            "name": name,
            "description": description,
            "type": type_,
            "uplinkBandwidthBits": uplink_bandwidth_bits,
            "downlinkBandwidthBits": downlink_bandwidth_bits,
            "uplinkDelayMs": uplink_delay_ms,
            "downlinkDelayMs": downlink_delay_ms,
            "uplinkJitterMs": uplink_jitter_ms,
            "downlinkJitterMs": downlink_jitter_ms,
            "uplinkLossPercent": uplink_loss_percent,
            "downlinkLossPercent": downlink_loss_percent,
        },
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a network profile.

    Args:
        arn(str): The ARN of the network profile to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.network_profile.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.network_profile.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="delete_network_profile",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a network profile.

    Args:
        arn(str): The ARN of the network profile to return information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.network_profile.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.network_profile.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="get_network_profile",
        op_kwargs={"arn": arn},
    )


async def list_all(
    hub, ctx, arn: str, type_: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of available network profiles.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the project for which you want to list network profiles.
        type_(str, optional): The type of network profile to return information about. Valid values are listed here. Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.network_profile.list_all(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.network_profile.list_all arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_network_profiles",
        op_kwargs={"arn": arn, "type": type_, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    arn: str,
    name: str = None,
    description: str = None,
    type_: str = None,
    uplink_bandwidth_bits: int = None,
    downlink_bandwidth_bits: int = None,
    uplink_delay_ms: int = None,
    downlink_delay_ms: int = None,
    uplink_jitter_ms: int = None,
    downlink_jitter_ms: int = None,
    uplink_loss_percent: int = None,
    downlink_loss_percent: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the network profile.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the project for which you want to update network profile settings.
        name(str, optional): The name of the network profile about which you are returning information. Defaults to None.
        description(str, optional): The description of the network profile about which you are returning information. Defaults to None.
        type_(str, optional): The type of network profile to return information about. Valid values are listed here. Defaults to None.
        uplink_bandwidth_bits(int, optional): The data throughput rate in bits per second, as an integer from 0 to 104857600. Defaults to None.
        downlink_bandwidth_bits(int, optional): The data throughput rate in bits per second, as an integer from 0 to 104857600. Defaults to None.
        uplink_delay_ms(int, optional): Delay time for all packets to destination in milliseconds as an integer from 0 to 2000. Defaults to None.
        downlink_delay_ms(int, optional): Delay time for all packets to destination in milliseconds as an integer from 0 to 2000. Defaults to None.
        uplink_jitter_ms(int, optional): Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000. Defaults to None.
        downlink_jitter_ms(int, optional): Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000. Defaults to None.
        uplink_loss_percent(int, optional): Proportion of transmitted packets that fail to arrive from 0 to 100 percent. Defaults to None.
        downlink_loss_percent(int, optional): Proportion of received packets that fail to arrive from 0 to 100 percent. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.network_profile.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.network_profile.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="update_network_profile",
        op_kwargs={
            "arn": arn,
            "name": name,
            "description": description,
            "type": type_,
            "uplinkBandwidthBits": uplink_bandwidth_bits,
            "downlinkBandwidthBits": downlink_bandwidth_bits,
            "uplinkDelayMs": uplink_delay_ms,
            "downlinkDelayMs": downlink_delay_ms,
            "uplinkJitterMs": uplink_jitter_ms,
            "downlinkJitterMs": downlink_jitter_ms,
            "uplinkLossPercent": uplink_loss_percent,
            "downlinkLossPercent": downlink_loss_percent,
        },
    )
