"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a job.

    Args:
        arn(str): The job's ARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.job.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.job.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="devicefarm", operation="get_job", op_kwargs={"arn": arn}
    )


async def stop(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Initiates a stop request for the current job. AWS Device Farm immediately stops the job on the device where tests have not started. You are not billed for this device. On the device where tests have started, setup suite and teardown suite tests run to completion on the device. You are billed for setup, teardown, and any tests that were in progress or already completed.

    Args:
        arn(str): Represents the Amazon Resource Name (ARN) of the Device Farm job to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.job.stop(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.job.stop arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="devicefarm", operation="stop_job", op_kwargs={"arn": arn}
    )
