"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    package_cleanup: bool = None,
    exclude_app_packages_from_cleanup: List = None,
    reboot_after_use: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a profile that can be applied to one or more private fleet device instances.

    Args:
        name(str): The name of your instance profile.
        description(str, optional): The description of your instance profile. Defaults to None.
        package_cleanup(bool, optional): When set to true, Device Farm removes app packages after a test run. The default value is false for private devices. Defaults to None.
        exclude_app_packages_from_cleanup(List, optional): An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run. The list of packages is considered only if you set packageCleanup to true. Defaults to None.
        reboot_after_use(bool, optional): When set to true, Device Farm reboots the instance after a test run. The default value is true. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.instance_profile.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.instance_profile.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="create_instance_profile",
        op_kwargs={
            "name": name,
            "description": description,
            "packageCleanup": package_cleanup,
            "excludeAppPackagesFromCleanup": exclude_app_packages_from_cleanup,
            "rebootAfterUse": reboot_after_use,
        },
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a profile that can be applied to one or more private device instances.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the instance profile you are requesting to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.instance_profile.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.instance_profile.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="delete_instance_profile",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified instance profile.

    Args:
        arn(str): The Amazon Resource Name (ARN) of an instance profile.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.instance_profile.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.instance_profile.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="get_instance_profile",
        op_kwargs={"arn": arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all the instance profiles in an AWS account.

    Args:
        max_results(int, optional): An integer that specifies the maximum number of items you want to return in the API response. Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.instance_profile.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.instance_profile.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_instance_profiles",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    arn: str,
    name: str = None,
    description: str = None,
    package_cleanup: bool = None,
    exclude_app_packages_from_cleanup: List = None,
    reboot_after_use: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates information about an existing private device instance profile.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the instance profile.
        name(str, optional): The updated name for your instance profile. Defaults to None.
        description(str, optional): The updated description for your instance profile. Defaults to None.
        package_cleanup(bool, optional): The updated choice for whether you want to specify package cleanup. The default value is false for private devices. Defaults to None.
        exclude_app_packages_from_cleanup(List, optional): An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run is over. The list of packages is only considered if you set packageCleanup to true. Defaults to None.
        reboot_after_use(bool, optional): The updated choice for whether you want to reboot the device after use. The default value is true. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.instance_profile.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.instance_profile.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="update_instance_profile",
        op_kwargs={
            "arn": arn,
            "name": name,
            "description": description,
            "packageCleanup": package_cleanup,
            "excludeAppPackagesFromCleanup": exclude_app_packages_from_cleanup,
            "rebootAfterUse": reboot_after_use,
        },
    )
