"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    project_arn: str,
    name: str,
    rules: List,
    description: str = None,
    max_devices: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a device pool.

    Args:
        project_arn(str): The ARN of the project for the device pool.
        name(str): The device pool's name.
        description(str, optional): The device pool's description. Defaults to None.
        rules(List): The device pool's rules.
        max_devices(int, optional): The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and meet the criteria that you assign for the rules parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter. By specifying the maximum number of devices, you can control the costs that you incur by running tests. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.device.pool.init.create(
                ctx, project_arn=value, name=value, rules=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.device.pool.init.create project_arn=value, name=value, rules=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="create_device_pool",
        op_kwargs={
            "projectArn": project_arn,
            "name": name,
            "description": description,
            "rules": rules,
            "maxDevices": max_devices,
        },
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.

    Args:
        arn(str): Represents the Amazon Resource Name (ARN) of the Device Farm device pool to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.device.pool.init.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.device.pool.init.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="delete_device_pool",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a device pool.

    Args:
        arn(str): The device pool's ARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.device.pool.init.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.device.pool.init.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="get_device_pool",
        op_kwargs={"arn": arn},
    )


async def list_all(
    hub, ctx, arn: str, type_: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about device pools.

    Args:
        arn(str): The project ARN.
        type_(str, optional): The device pools' type. Allowed values include:   CURATED: A device pool that is created and managed by AWS Device Farm.   PRIVATE: A device pool that is created and managed by the device pool developer.  . Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.device.pool.init.list_all(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.device.pool.init.list_all arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_device_pools",
        op_kwargs={"arn": arn, "type": type_, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    arn: str,
    name: str = None,
    description: str = None,
    rules: List = None,
    max_devices: int = None,
    clear_max_devices: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates are all-or-nothing, meaning they can only be updated as a whole (or not at all).

    Args:
        arn(str): The Amazon Resource Name (ARN) of the Device Farm device pool to update.
        name(str, optional): A string that represents the name of the device pool to update. Defaults to None.
        description(str, optional): A description of the device pool to update. Defaults to None.
        rules(List, optional): Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your request, the update replaces the existing rules. Defaults to None.
        max_devices(int, optional): The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and that meet the criteria that you assign for the rules parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter. By specifying the maximum number of devices, you can control the costs that you incur by running tests. If you use this parameter in your request, you cannot use the clearMaxDevices parameter in the same request. Defaults to None.
        clear_max_devices(bool, optional): Sets whether the maxDevices parameter applies to your device pool. If you set this parameter to true, the maxDevices parameter does not apply, and Device Farm does not limit the number of devices that it adds to your device pool. In this case, Device Farm adds all available devices that meet the criteria specified in the rules parameter. If you use this parameter in your request, you cannot use the maxDevices parameter in the same request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.device.pool.init.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.device.pool.init.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="update_device_pool",
        op_kwargs={
            "arn": arn,
            "name": name,
            "description": description,
            "rules": rules,
            "maxDevices": max_devices,
            "clearMaxDevices": clear_max_devices,
        },
    )
