"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    device_pool_arn: str,
    app_arn: str = None,
    test_type: str = None,
    test: Dict = None,
    configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about compatibility with a device pool.

    Args:
        device_pool_arn(str): The device pool's ARN.
        app_arn(str, optional): The ARN of the app that is associated with the specified device pool. Defaults to None.
        test_type(str, optional): The test type for the specified device pool. Allowed values include the following:   BUILTIN_FUZZ.   BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing screenshots at the same time.   APPIUM_JAVA_JUNIT.   APPIUM_JAVA_TESTNG.   APPIUM_PYTHON.   APPIUM_NODE.   APPIUM_RUBY.   APPIUM_WEB_JAVA_JUNIT.   APPIUM_WEB_JAVA_TESTNG.   APPIUM_WEB_PYTHON.   APPIUM_WEB_NODE.   APPIUM_WEB_RUBY.   CALABASH.   INSTRUMENTATION.   UIAUTOMATION.   UIAUTOMATOR.   XCTEST.   XCTEST_UI.  . Defaults to None.
        test(Dict, optional): Information about the uploaded test to be run against the device pool. Defaults to None.
        configuration(Dict, optional): An object that contains information about the settings for a run. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.device.pool.compatibility.get(
                ctx, device_pool_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.device.pool.compatibility.get device_pool_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="get_device_pool_compatibility",
        op_kwargs={
            "devicePoolArn": device_pool_arn,
            "appArn": app_arn,
            "testType": test_type,
            "test": test,
            "configuration": configuration,
        },
    )
