"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a device instance that belongs to a private device fleet.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the instance you're requesting information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.device.instance.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.device.instance.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="get_device_instance",
        op_kwargs={"arn": arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the private device instances associated with one or more AWS accounts.

    Args:
        max_results(int, optional): An integer that specifies the maximum number of items you want to return in the API response. Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.device.instance.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.device.instance.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_device_instances",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub, ctx, arn: str, profile_arn: str = None, labels: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates information about a private device instance.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the device instance.
        profile_arn(str, optional): The ARN of the profile that you want to associate with the device instance. Defaults to None.
        labels(List, optional): An array of strings that you want to associate with the device instance. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.device.instance.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.device.instance.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="update_device_instance",
        op_kwargs={"arn": arn, "profileArn": profile_arn, "labels": labels},
    )
