"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, arn: str, type_: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about artifacts.

    Args:
        arn(str): The run, job, suite, or test ARN.
        type_(str): The artifacts' type. Allowed values include:   FILE   LOG   SCREENSHOT  .
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devicefarm.artifact.list_all(ctx, arn=value, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devicefarm.artifact.list_all arn=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devicefarm",
        operation="list_artifacts",
        op_kwargs={"arn": arn, "type": type_, "nextToken": next_token},
    )
