"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def start(hub, ctx, graph_arn: str, account_id: str) -> None:
    r"""
    **Autogenerated function**

    Sends a request to enable data ingest for a member account that has a status of ACCEPTED_BUT_DISABLED. For valid member accounts, the status is updated as follows.   If Detective enabled the member account, then the new status is ENABLED.   If Detective cannot enable the member account, the status remains ACCEPTED_BUT_DISABLED.

    Args:
        graph_arn(str): The ARN of the behavior graph.
        account_id(str): The account ID of the member account to try to enable. The account must be an invited member account with a status of ACCEPTED_BUT_DISABLED. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.detective.monitoring_member.start(
                ctx, graph_arn=value, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.detective.monitoring_member.start graph_arn=value, account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="detective",
        operation="start_monitoring_member",
        op_kwargs={"GraphArn": graph_arn, "AccountId": account_id},
    )
