"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def disassociate(hub, ctx, graph_arn: str) -> None:
    r"""
    **Autogenerated function**

    Removes the member account from the specified behavior graph. This operation can only be called by a member account that has the ENABLED status.

    Args:
        graph_arn(str): The ARN of the behavior graph to remove the member account from. The member account's member status in the behavior graph must be ENABLED.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.detective.membership.disassociate(ctx, graph_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.detective.membership.disassociate graph_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="detective",
        operation="disassociate_membership",
        op_kwargs={"GraphArn": graph_arn},
    )
