"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def accept(hub, ctx, graph_arn: str) -> None:
    r"""
    **Autogenerated function**

    Accepts an invitation for the member account to contribute data to a behavior graph. This operation can only be called by an invited member account.  The request provides the ARN of behavior graph. The member account status in the graph must be INVITED.

    Args:
        graph_arn(str): The ARN of the behavior graph that the member account is accepting the invitation for. The member account status in the behavior graph must be INVITED.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.detective.invitation.accept(ctx, graph_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.detective.invitation.accept graph_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="detective",
        operation="accept_invitation",
        op_kwargs={"GraphArn": graph_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the list of open and accepted behavior graph invitations for the member account. This operation can only be called by a member account. Open invitations are invitations that the member account has not responded to. The results do not include behavior graphs for which the member account declined the invitation. The results also do not include behavior graphs that the member account resigned from or was removed from.

    Args:
        next_token(str, optional): For requests to retrieve the next page of results, the pagination token that was returned with the previous page of results. The initial request does not include a pagination token. Defaults to None.
        max_results(int, optional): The maximum number of behavior graph invitations to return in the response. The total must be less than the overall limit on the number of results to return, which is currently 200. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.detective.invitation.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.detective.invitation.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="detective",
        operation="list_invitations",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def reject(hub, ctx, graph_arn: str) -> None:
    r"""
    **Autogenerated function**

    Rejects an invitation to contribute the account data to a behavior graph. This operation must be called by a member account that has the INVITED status.

    Args:
        graph_arn(str): The ARN of the behavior graph to reject the invitation to. The member account's current member status in the behavior graph must be INVITED.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.detective.invitation.reject(ctx, graph_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.detective.invitation.reject graph_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="detective",
        operation="reject_invitation",
        op_kwargs={"GraphArn": graph_arn},
    )
