"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new behavior graph for the calling account, and sets that account as the administrator account. This operation is called by the account that is enabling Detective. Before you try to enable Detective, make sure that your account has been enrolled in Amazon GuardDuty for at least 48 hours. If you do not meet this requirement, you cannot enable Detective. If you do meet the GuardDuty prerequisite, then when you make the request to enable Detective, it checks whether your data volume is within the Detective quota. If it exceeds the quota, then you cannot enable Detective.  The operation also enables Detective for the calling account in the currently selected Region. It returns the ARN of the new behavior graph.  CreateGraph triggers a process to create the corresponding data tables for the new behavior graph. An account can only be the administrator account for one behavior graph within a Region. If the same account calls CreateGraph with the same administrator account, it always returns the same behavior graph ARN. It does not create a new behavior graph.

    Args:
        tags(Dict, optional): The tags to assign to the new behavior graph. You can add up to 50 tags. For each tag, you provide the tag key and the tag value. Each tag key can contain up to 128 characters. Each tag value can contain up to 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.detective.graph.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.detective.graph.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="detective",
        operation="create_graph",
        op_kwargs={"Tags": tags},
    )


async def delete(hub, ctx, graph_arn: str) -> None:
    r"""
    **Autogenerated function**

    Disables the specified behavior graph and queues it to be deleted. This operation removes the graph from each member account's list of behavior graphs.  DeleteGraph can only be called by the administrator account for a behavior graph.

    Args:
        graph_arn(str): The ARN of the behavior graph to disable.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.detective.graph.delete(ctx, graph_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.detective.graph.delete graph_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="detective",
        operation="delete_graph",
        op_kwargs={"GraphArn": graph_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of behavior graphs that the calling account is an administrator account of. This operation can only be called by an administrator account. Because an account can currently only be the administrator of one behavior graph within a Region, the results always contain a single behavior graph.

    Args:
        next_token(str, optional): For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token. Defaults to None.
        max_results(int, optional): The maximum number of graphs to return at a time. The total must be less than the overall limit on the number of results to return, which is currently 200. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.detective.graph.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.detective.graph.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="detective",
        operation="list_graphs",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
