"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, resource_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List all of the tags for a DAX cluster. You can call ListTags up to 10 times per second, per account.

    Args:
        resource_name(str): The name of the DAX resource to which the tags belong.
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.tags.list(ctx, resource_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.tags.list resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="list_tags",
        op_kwargs={"ResourceName": resource_name, "NextToken": next_token},
    )
