"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, subnet_group_name: str, subnet_ids: List, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new subnet group.

    Args:
        subnet_group_name(str): A name for the subnet group. This value is stored as a lowercase string. .
        description(str, optional): A description for the subnet group. Defaults to None.
        subnet_ids(List): A list of VPC subnet IDs for the subnet group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.subnet_group.create(
                ctx, subnet_group_name=value, subnet_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.subnet_group.create subnet_group_name=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="create_subnet_group",
        op_kwargs={
            "SubnetGroupName": subnet_group_name,
            "Description": description,
            "SubnetIds": subnet_ids,
        },
    )


async def delete(hub, ctx, subnet_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a subnet group.  You cannot delete a subnet group if it is associated with any DAX clusters.

    Args:
        subnet_group_name(str): The name of the subnet group to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.subnet_group.delete(ctx, subnet_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.subnet_group.delete subnet_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="delete_subnet_group",
        op_kwargs={"SubnetGroupName": subnet_group_name},
    )


async def describe_all(
    hub,
    ctx,
    subnet_group_names: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of subnet group descriptions. If a subnet group name is specified, the list will contain only the description of that group.

    Args:
        subnet_group_names(List, optional): The name of the subnet group. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. The value for MaxResults must be between 20 and 100. Defaults to None.
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.subnet_group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.subnet_group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="describe_subnet_groups",
        op_kwargs={
            "SubnetGroupNames": subnet_group_names,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub, ctx, subnet_group_name: str, description: str = None, subnet_ids: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies an existing subnet group.

    Args:
        subnet_group_name(str): The name of the subnet group.
        description(str, optional): A description of the subnet group. Defaults to None.
        subnet_ids(List, optional): A list of subnet IDs in the subnet group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.subnet_group.update(ctx, subnet_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.subnet_group.update subnet_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="update_subnet_group",
        op_kwargs={
            "SubnetGroupName": subnet_group_name,
            "Description": description,
            "SubnetIds": subnet_ids,
        },
    )
