"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_name: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Associates a set of tags with a DAX resource. You can call TagResource up to 5 times per second, per account.

    Args:
        resource_name(str): The name of the DAX resource to which tags should be added.
        tags(List): The tags to be assigned to the DAX resource. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.resource.tag(ctx, resource_name=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.resource.tag resource_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="tag_resource",
        op_kwargs={"ResourceName": resource_name, "Tags": tags},
    )


async def untag(hub, ctx, resource_name: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the association of tags from a DAX resource. You can call UntagResource up to 5 times per second, per account.

    Args:
        resource_name(str): The name of the DAX resource from which the tags should be removed.
        tag_keys(List): A list of tag keys. If the DAX cluster has any tags with these keys, then the tags are removed from the cluster.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.resource.untag(ctx, resource_name=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.resource.untag resource_name=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="untag_resource",
        op_kwargs={"ResourceName": resource_name, "TagKeys": tag_keys},
    )
