"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def decrease(
    hub,
    ctx,
    cluster_name: str,
    new_replication_factor: int,
    availability_zones: List = None,
    node_ids_to_remove: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more nodes from a DAX cluster.  You cannot use DecreaseReplicationFactor to remove the last node in a DAX cluster. If you need to do this, use DeleteCluster instead.

    Args:
        cluster_name(str): The name of the DAX cluster from which you want to remove nodes.
        new_replication_factor(int): The new number of nodes for the DAX cluster.
        availability_zones(List, optional): The Availability Zone(s) from which to remove nodes. Defaults to None.
        node_ids_to_remove(List, optional): The unique identifiers of the nodes to be removed from the cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.replication_factor.decrease(
                ctx, cluster_name=value, new_replication_factor=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.replication_factor.decrease cluster_name=value, new_replication_factor=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="decrease_replication_factor",
        op_kwargs={
            "ClusterName": cluster_name,
            "NewReplicationFactor": new_replication_factor,
            "AvailabilityZones": availability_zones,
            "NodeIdsToRemove": node_ids_to_remove,
        },
    )


async def increase(
    hub,
    ctx,
    cluster_name: str,
    new_replication_factor: int,
    availability_zones: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more nodes to a DAX cluster.

    Args:
        cluster_name(str): The name of the DAX cluster that will receive additional nodes.
        new_replication_factor(int): The new number of nodes for the DAX cluster.
        availability_zones(List, optional): The Availability Zones (AZs) in which the cluster nodes will be created. All nodes belonging to the cluster are placed in these Availability Zones. Use this parameter if you want to distribute the nodes across multiple AZs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.replication_factor.increase(
                ctx, cluster_name=value, new_replication_factor=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.replication_factor.increase cluster_name=value, new_replication_factor=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="increase_replication_factor",
        op_kwargs={
            "ClusterName": cluster_name,
            "NewReplicationFactor": new_replication_factor,
            "AvailabilityZones": availability_zones,
        },
    )
