"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    parameter_group_name: str,
    source: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the detailed parameter list for a particular parameter group.

    Args:
        parameter_group_name(str): The name of the parameter group.
        source(str, optional): How the parameter is defined. For example, system denotes a system-defined parameter. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. The value for MaxResults must be between 20 and 100. Defaults to None.
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.parameter.init.describe_all(ctx, parameter_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.parameter.init.describe_all parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="describe_parameters",
        op_kwargs={
            "ParameterGroupName": parameter_group_name,
            "Source": source,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
