"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, parameter_group_name: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new parameter group. A parameter group is a collection of parameters that you apply to all of the nodes in a DAX cluster.

    Args:
        parameter_group_name(str): The name of the parameter group to apply to all of the clusters in this replication group.
        description(str, optional): A description of the parameter group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.parameter.group.create(ctx, parameter_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.parameter.group.create parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="create_parameter_group",
        op_kwargs={
            "ParameterGroupName": parameter_group_name,
            "Description": description,
        },
    )


async def delete(hub, ctx, parameter_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any DAX clusters.

    Args:
        parameter_group_name(str): The name of the parameter group to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.parameter.group.delete(ctx, parameter_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.parameter.group.delete parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="delete_parameter_group",
        op_kwargs={"ParameterGroupName": parameter_group_name},
    )


async def describe_all(
    hub,
    ctx,
    parameter_group_names: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of parameter group descriptions. If a parameter group name is specified, the list will contain only the descriptions for that group.

    Args:
        parameter_group_names(List, optional): The names of the parameter groups. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. The value for MaxResults must be between 20 and 100. Defaults to None.
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.parameter.group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.parameter.group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="describe_parameter_groups",
        op_kwargs={
            "ParameterGroupNames": parameter_group_names,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub, ctx, parameter_group_name: str, parameter_name_values: List
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.

    Args:
        parameter_group_name(str): The name of the parameter group.
        parameter_name_values(List): An array of name-value pairs for the parameters in the group. Each element in the array represents a single parameter.   record-ttl-millis and query-ttl-millis are the only supported parameter names. For more details, see Configuring TTL Settings. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.parameter.group.update(
                ctx, parameter_group_name=value, parameter_name_values=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.parameter.group.update parameter_group_name=value, parameter_name_values=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="update_parameter_group",
        op_kwargs={
            "ParameterGroupName": parameter_group_name,
            "ParameterNameValues": parameter_name_values,
        },
    )
