"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def reboot(hub, ctx, cluster_name: str, node_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Reboots a single node of a DAX cluster. The reboot action takes place as soon as possible. During the reboot, the node status is set to REBOOTING.   RebootNode restarts the DAX engine process and does not remove the contents of the cache.

    Args:
        cluster_name(str): The name of the DAX cluster containing the node to be rebooted.
        node_id(str): The system-assigned ID of the node to be rebooted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.node.reboot(ctx, cluster_name=value, node_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.node.reboot cluster_name=value, node_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="reboot_node",
        op_kwargs={"ClusterName": cluster_name, "NodeId": node_id},
    )
