"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    source_name: str = None,
    source_type: str = None,
    start_time: str = None,
    end_time: str = None,
    duration: int = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns events related to DAX clusters and parameter groups. You can obtain events specific to a particular DAX cluster or parameter group by providing the name as a parameter. By default, only the events occurring within the last 24 hours are returned; however, you can retrieve up to 14 days' worth of events if necessary.

    Args:
        source_name(str, optional): The identifier of the event source for which events will be returned. If not specified, then all sources are included in the response. Defaults to None.
        source_type(str, optional): The event source to retrieve events for. If no value is specified, all events are returned. Defaults to None.
        start_time(str, optional): The beginning of the time interval to retrieve events for, specified in ISO 8601 format. Defaults to None.
        end_time(str, optional): The end of the time interval for which to retrieve events, specified in ISO 8601 format. Defaults to None.
        duration(int, optional): The number of minutes' worth of events to retrieve. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. The value for MaxResults must be between 20 and 100. Defaults to None.
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.event.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.event.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="describe_events",
        op_kwargs={
            "SourceName": source_name,
            "SourceType": source_type,
            "StartTime": start_time,
            "EndTime": end_time,
            "Duration": duration,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
