"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cluster_name: str,
    node_type: str,
    replication_factor: int,
    iam_role_arn: str,
    description: str = None,
    availability_zones: List = None,
    subnet_group_name: str = None,
    security_group_ids: List = None,
    preferred_maintenance_window: str = None,
    notification_topic_arn: str = None,
    parameter_group_name: str = None,
    tags: List = None,
    sse_specification: Dict = None,
    cluster_endpoint_encryption_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a DAX cluster. All nodes in the cluster run the same DAX caching software.

    Args:
        cluster_name(str): The cluster identifier. This parameter is stored as a lowercase string.  Constraints:    A name must contain from 1 to 20 alphanumeric characters or hyphens.   The first character must be a letter.   A name cannot end with a hyphen or contain two consecutive hyphens.  .
        node_type(str): The compute and memory capacity of the nodes in the cluster.
        description(str, optional): A description of the cluster. Defaults to None.
        replication_factor(int): The number of nodes in the DAX cluster. A replication factor of 1 will create a single-node cluster, without any read replicas. For additional fault tolerance, you can create a multiple node cluster with one or more read replicas. To do this, set ReplicationFactor to a number between 3 (one primary and two read replicas) and 10 (one primary and nine read replicas). If the AvailabilityZones parameter is provided, its length must equal the ReplicationFactor.  AWS recommends that you have at least two read replicas per cluster. .
        availability_zones(List, optional): The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created or updated. If provided, the length of this list must equal the ReplicationFactor parameter. If you omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability. Defaults to None.
        subnet_group_name(str, optional): The name of the subnet group to be used for the replication group.  DAX clusters can only run in an Amazon VPC environment. All of the subnets that you specify in a subnet group must exist in the same VPC. . Defaults to None.
        security_group_ids(List, optional): A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security group ID is system-generated.) If this parameter is not specified, DAX assigns the default VPC security group to each node. Defaults to None.
        preferred_maintenance_window(str, optional): Specifies the weekly time range during which maintenance on the DAX cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for ddd are:    sun     mon     tue     wed     thu     fri     sat    Example: sun:05:00-sun:09:00   If you don't specify a preferred maintenance window when you create or modify a cache cluster, DAX assigns a 60-minute maintenance window on a randomly selected day of the week. . Defaults to None.
        notification_topic_arn(str, optional): The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will be sent.  The Amazon SNS topic owner must be same as the DAX cluster owner. . Defaults to None.
        iam_role_arn(str): A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.
        parameter_group_name(str, optional): The parameter group to be associated with the DAX cluster. Defaults to None.
        tags(List, optional): A set of tags to associate with the DAX cluster. . Defaults to None.
        sse_specification(Dict, optional): Represents the settings used to enable server-side encryption on the cluster. Defaults to None.
        cluster_endpoint_encryption_type(str, optional): The type of encryption the cluster's endpoint should support. Values are:    NONE for no encryption    TLS for Transport Layer Security  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.cluster.create(
                ctx,
                cluster_name=value,
                node_type=value,
                replication_factor=value,
                iam_role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.cluster.create cluster_name=value, node_type=value, replication_factor=value, iam_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="create_cluster",
        op_kwargs={
            "ClusterName": cluster_name,
            "NodeType": node_type,
            "Description": description,
            "ReplicationFactor": replication_factor,
            "AvailabilityZones": availability_zones,
            "SubnetGroupName": subnet_group_name,
            "SecurityGroupIds": security_group_ids,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "NotificationTopicArn": notification_topic_arn,
            "IamRoleArn": iam_role_arn,
            "ParameterGroupName": parameter_group_name,
            "Tags": tags,
            "SSESpecification": sse_specification,
            "ClusterEndpointEncryptionType": cluster_endpoint_encryption_type,
        },
    )


async def delete(hub, ctx, cluster_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a previously provisioned DAX cluster. DeleteCluster deletes all associated nodes, node endpoints and the DAX cluster itself. When you receive a successful response from this action, DAX immediately begins deleting the cluster; you cannot cancel or revert this action.

    Args:
        cluster_name(str): The name of the cluster to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.cluster.delete(ctx, cluster_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.cluster.delete cluster_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="delete_cluster",
        op_kwargs={"ClusterName": cluster_name},
    )


async def describe_all(
    hub,
    ctx,
    cluster_names: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all provisioned DAX clusters if no cluster identifier is specified, or about a specific DAX cluster if a cluster identifier is supplied. If the cluster is in the CREATING state, only cluster level information will be displayed until all of the nodes are successfully provisioned. If the cluster is in the DELETING state, only cluster level information will be displayed. If nodes are currently being added to the DAX cluster, node endpoint information and creation time for the additional nodes will not be displayed until they are completely provisioned. When the DAX cluster state is available, the cluster is ready for use. If nodes are currently being removed from the DAX cluster, no endpoint information for the removed nodes is displayed.

    Args:
        cluster_names(List, optional): The names of the DAX clusters being described. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. The value for MaxResults must be between 20 and 100. Defaults to None.
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.cluster.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.cluster.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="describe_clusters",
        op_kwargs={
            "ClusterNames": cluster_names,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    cluster_name: str,
    description: str = None,
    preferred_maintenance_window: str = None,
    notification_topic_arn: str = None,
    notification_topic_status: str = None,
    parameter_group_name: str = None,
    security_group_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the settings for a DAX cluster. You can use this action to change one or more cluster configuration parameters by specifying the parameters and the new values.

    Args:
        cluster_name(str): The name of the DAX cluster to be modified.
        description(str, optional): A description of the changes being made to the cluster. Defaults to None.
        preferred_maintenance_window(str, optional): A range of time when maintenance of DAX cluster software will be performed. For example: sun:01:00-sun:09:00. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window. Defaults to None.
        notification_topic_arn(str, optional): The Amazon Resource Name (ARN) that identifies the topic. Defaults to None.
        notification_topic_status(str, optional): The current state of the topic. A value of “active” means that notifications will be sent to the topic. A value of “inactive” means that notifications will not be sent to the topic. Defaults to None.
        parameter_group_name(str, optional): The name of a parameter group for this cluster. Defaults to None.
        security_group_ids(List, optional): A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this parameter is not specified, DAX assigns the default VPC security group to each node. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dax.cluster.update(ctx, cluster_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dax.cluster.update cluster_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dax",
        operation="update_cluster",
        op_kwargs={
            "ClusterName": cluster_name,
            "Description": description,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "NotificationTopicArn": notification_topic_arn,
            "NotificationTopicStatus": notification_topic_status,
            "ParameterGroupName": parameter_group_name,
            "SecurityGroupIds": security_group_ids,
        },
    )
