"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    source_location_arn: str,
    destination_location_arn: str,
    cloud_watch_log_group_arn: str = None,
    name: str = None,
    options: Dict = None,
    excludes: List = None,
    schedule: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a task. A task includes a source location and a destination location, and a configuration that specifies how data is transferred. A task always transfers data from the source location to the destination location. The configuration specifies options such as task scheduling, bandwidth limits, etc. A task is the complete definition of a data transfer. When you create a task that transfers data between AWS services in different AWS Regions, one of the two locations that you specify must reside in the Region where DataSync is being used. The other location must be specified in a different Region. You can transfer data between commercial AWS Regions except for China, or between AWS GovCloud (US-East and US-West) Regions.  When you use DataSync to copy files or objects between AWS Regions, you pay for data transfer between Regions. This is billed as data transfer OUT from your source Region to your destination Region. For more information, see Data Transfer pricing.

    Args:
        source_location_arn(str): The Amazon Resource Name (ARN) of the source location for the task.
        destination_location_arn(str): The Amazon Resource Name (ARN) of an AWS storage resource's location. .
        cloud_watch_log_group_arn(str, optional): The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task. . Defaults to None.
        name(str, optional): The name of a task. This value is a text reference that is used to identify the task in the console. . Defaults to None.
        options(Dict, optional): The set of configuration options that control the behavior of a single execution of the task that occurs when you call StartTaskExecution. You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on. For each individual task execution, you can override these options by specifying the OverrideOptions before starting the task execution. For more information, see the StartTaskExecution operation. . Defaults to None.
        excludes(List, optional): A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, "/folder1|/folder2".   . Defaults to None.
        schedule(Dict, optional): Specifies a schedule used to periodically transfer files from a source to a destination location. The schedule should be specified in UTC time. For more information, see Scheduling your task. Defaults to None.
        tags(List, optional): The key-value pair that represents the tag that you want to add to the resource. The value can be an empty string. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.init.create(
                ctx, source_location_arn=value, destination_location_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.init.create source_location_arn=value, destination_location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="create_task",
        op_kwargs={
            "SourceLocationArn": source_location_arn,
            "DestinationLocationArn": destination_location_arn,
            "CloudWatchLogGroupArn": cloud_watch_log_group_arn,
            "Name": name,
            "Options": options,
            "Excludes": excludes,
            "Schedule": schedule,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, task_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a task.

    Args:
        task_arn(str): The Amazon Resource Name (ARN) of the task to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.init.delete(ctx, task_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.init.delete task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="delete_task",
        op_kwargs={"TaskArn": task_arn},
    )


async def describe(hub, ctx, task_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata about a task.

    Args:
        task_arn(str): The Amazon Resource Name (ARN) of the task to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.init.describe(ctx, task_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.init.describe task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="describe_task",
        op_kwargs={"TaskArn": task_arn},
    )


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all the tasks.

    Args:
        max_results(int, optional): The maximum number of tasks to return. Defaults to None.
        next_token(str, optional): An opaque string that indicates the position at which to begin the next list of tasks. Defaults to None.
        filters(List, optional): You can use API filters to narrow down the list of resources returned by ListTasks. For example, to retrieve all tasks on a specific source location, you can use ListTasks with filter name LocationId and Operator Equals with the ARN for the location. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="list_tasks",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
        },
    )


async def update(
    hub,
    ctx,
    task_arn: str,
    options: Dict = None,
    excludes: List = None,
    schedule: Dict = None,
    name: str = None,
    cloud_watch_log_group_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the metadata associated with a task.

    Args:
        task_arn(str): The Amazon Resource Name (ARN) of the resource name of the task to update.
        options(Dict, optional): Represents the options that are available to control the behavior of a StartTaskExecution operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on. A task has a set of default options associated with it. If you don't specify an option in StartTaskExecution, the default value is used. You can override the defaults options on each task execution by specifying an overriding Options value to StartTaskExecution. Defaults to None.
        excludes(List, optional): A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: "/folder1|/folder2"   . Defaults to None.
        schedule(Dict, optional): Specifies a schedule used to periodically transfer files from a source to a destination location. You can configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the day or hour you want the task to execute. The time you specify is UTC time. For more information, see Scheduling your task. Defaults to None.
        name(str, optional): The name of the task to update. Defaults to None.
        cloud_watch_log_group_arn(str, optional): The Amazon Resource Name (ARN) of the resource name of the CloudWatch LogGroup. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.init.update(ctx, task_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.init.update task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="update_task",
        op_kwargs={
            "TaskArn": task_arn,
            "Options": options,
            "Excludes": excludes,
            "Schedule": schedule,
            "Name": name,
            "CloudWatchLogGroupArn": cloud_watch_log_group_arn,
        },
    )
