"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, task_execution_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels execution of a task.  When you cancel a task execution, the transfer of some files is abruptly interrupted. The contents of files that are transferred to the destination might be incomplete or inconsistent with the source files. However, if you start a new task execution on the same task and you allow the task execution to complete, file content on the destination is complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, AWS DataSync successfully complete the transfer when you start the next task execution.

    Args:
        task_execution_arn(str): The Amazon Resource Name (ARN) of the task execution to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.execution.cancel(ctx, task_execution_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.execution.cancel task_execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="cancel_task_execution",
        op_kwargs={"TaskExecutionArn": task_execution_arn},
    )


async def describe(hub, ctx, task_execution_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed metadata about a task that is being executed.

    Args:
        task_execution_arn(str): The Amazon Resource Name (ARN) of the task that is being executed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.execution.describe(ctx, task_execution_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.execution.describe task_execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="describe_task_execution",
        op_kwargs={"TaskExecutionArn": task_execution_arn},
    )


async def list_all(
    hub, ctx, task_arn: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of executed tasks.

    Args:
        task_arn(str, optional): The Amazon Resource Name (ARN) of the task whose tasks you want to list. Defaults to None.
        max_results(int, optional): The maximum number of executed tasks to list. Defaults to None.
        next_token(str, optional): An opaque string that indicates the position at which to begin the next list of the executed tasks. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.execution.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.execution.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="list_task_executions",
        op_kwargs={
            "TaskArn": task_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def start(
    hub, ctx, task_arn: str, override_options: Dict = None, includes: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a specific invocation of a task. A TaskExecution value represents an individual run of a task. Each task can have at most one TaskExecution at a time.  TaskExecution has the following transition phases: INITIALIZING | PREPARING | TRANSFERRING | VERIFYING | SUCCESS/FAILURE.  For detailed information, see the Task Execution section in the Components and Terminology topic in the AWS DataSync User Guide.

    Args:
        task_arn(str): The Amazon Resource Name (ARN) of the task to start.
        override_options(Dict, optional): Represents the options that are available to control the behavior of a StartTaskExecution operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on. A task has a set of default options associated with it. If you don't specify an option in StartTaskExecution, the default value is used. You can override the defaults options on each task execution by specifying an overriding Options value to StartTaskExecution. Defaults to None.
        includes(List, optional): A list of filter rules that determines which files to include when running a task. The pattern should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe). For example: "/folder1|/folder2"   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.execution.start(ctx, task_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.execution.start task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="start_task_execution",
        op_kwargs={
            "TaskArn": task_arn,
            "OverrideOptions": override_options,
            "Includes": includes,
        },
    )


async def update(hub, ctx, task_execution_arn: str, options: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates execution of a task. You can modify bandwidth throttling for a task execution that is running or queued. For more information, see Adjusting Bandwidth Throttling for a Task Execution.  The only Option that can be modified by UpdateTaskExecution is  BytesPerSecond .

    Args:
        task_execution_arn(str): The Amazon Resource Name (ARN) of the specific task execution that is being updated. .
        options(Dict): Represents the options that are available to control the behavior of a StartTaskExecution operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on. A task has a set of default options associated with it. If you don't specify an option in StartTaskExecution, the default value is used. You can override the defaults options on each task execution by specifying an overriding Options value to StartTaskExecution.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.task.execution.update(
                ctx, task_execution_arn=value, options=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.task.execution.update task_execution_arn=value, options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="update_task_execution",
        op_kwargs={"TaskExecutionArn": task_execution_arn, "Options": options},
    )
