"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Applies a key-value pair to an AWS resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource to apply the tag to.
        tags(List): The tags to apply.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes a tag from an AWS resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource to remove the tag from.
        keys(List): The keys in the key-value pair in the tag to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.resource.untag(ctx, resource_arn=value, keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.resource.untag resource_arn=value, keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Keys": keys},
    )
