"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    subdirectory: str,
    server_hostname: str,
    user: str,
    password: str,
    agent_arns: List,
    domain: str = None,
    mount_options: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Defines a file system on a Server Message Block (SMB) server that can be read from or written to.

    Args:
        subdirectory(str): The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.   Subdirectory must be specified with forward slashes. For example, /path/to/folder.  To transfer all the data in the folder you specified, DataSync needs to have permissions to mount the SMB share, as well as to access all the data in that share. To ensure this, either ensure that the user/password specified belongs to the user who can mount the share, and who has the appropriate permissions for all of the files and directories that you want DataSync to access, or use credentials of a member of the Backup Operators group to mount the share. Doing either enables the agent to access the data. For the agent to access directories, you must additionally enable all execute access.
        server_hostname(str): The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server. An agent that is installed on-premises uses this hostname to mount the SMB server in a network.  This name must either be DNS-compliant or must be an IP version 4 (IPv4) address. .
        user(str): The user who can mount the share, has the permissions to access files and folders in the SMB share. For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see user.
        domain(str, optional): The name of the Windows domain that the SMB server belongs to. Defaults to None.
        password(str): The password of the user who can mount the share, has the permissions to access files and folders in the SMB share.
        agent_arns(List): The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location. .
        mount_options(Dict, optional): The mount options used by DataSync to access the SMB server. Defaults to None.
        tags(List, optional): The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.smb.create(
                ctx,
                subdirectory=value,
                server_hostname=value,
                user=value,
                password=value,
                agent_arns=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.smb.create subdirectory=value, server_hostname=value, user=value, password=value, agent_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="create_location_smb",
        op_kwargs={
            "Subdirectory": subdirectory,
            "ServerHostname": server_hostname,
            "User": user,
            "Domain": domain,
            "Password": password,
            "AgentArns": agent_arns,
            "MountOptions": mount_options,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, location_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata, such as the path and user information about an SMB location.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the SMB location to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.smb.describe(ctx, location_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.smb.describe location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="describe_location_smb",
        op_kwargs={"LocationArn": location_arn},
    )


async def update(
    hub,
    ctx,
    location_arn: str,
    subdirectory: str = None,
    user: str = None,
    domain: str = None,
    password: str = None,
    agent_arns: List = None,
    mount_options: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates some of the parameters of a previously created location for Server Message Block (SMB) file system access. For information about creating an SMB location, see Creating a location for SMB.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the SMB location to update.
        subdirectory(str, optional): The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.   Subdirectory must be specified with forward slashes. For example, /path/to/folder.  To transfer all the data in the folder that you specified, DataSync must have permissions to mount the SMB share and to access all the data in that share. To ensure this, do either of the following:   Ensure that the user/password specified belongs to the user who can mount the share and who has the appropriate permissions for all of the files and directories that you want DataSync to access.   Use credentials of a member of the Backup Operators group to mount the share.    Doing either of these options enables the agent to access the data. For the agent to access directories, you must also enable all execute access. Defaults to None.
        user(str, optional): The user who can mount the share has the permissions to access files and folders in the SMB share. Defaults to None.
        domain(str, optional): The name of the Windows domain that the SMB server belongs to. Defaults to None.
        password(str, optional): The password of the user who can mount the share has the permissions to access files and folders in the SMB share. Defaults to None.
        agent_arns(List, optional): The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location. Defaults to None.
        mount_options(Dict, optional): Represents the mount options that are available for DataSync to access an SMB location. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.smb.update(ctx, location_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.smb.update location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="update_location_smb",
        op_kwargs={
            "LocationArn": location_arn,
            "Subdirectory": subdirectory,
            "User": user,
            "Domain": domain,
            "Password": password,
            "AgentArns": agent_arns,
            "MountOptions": mount_options,
        },
    )
