"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    s3_bucket_arn: str,
    s3_config: Dict,
    subdirectory: str = None,
    s3_storage_class: str = None,
    agent_arns: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an endpoint for an Amazon S3 bucket. For more information, see https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli in the AWS DataSync User Guide.

    Args:
        subdirectory(str, optional): A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is used to read data from the S3 source location or write data to the S3 destination. Defaults to None.
        s3_bucket_arn(str): The ARN of the Amazon S3 bucket. If the bucket is on an AWS Outpost, this must be an access point ARN.
        s3_storage_class(str, optional): The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. For buckets in AWS Regions, the storage class defaults to Standard. For buckets on AWS Outposts, the storage class defaults to AWS S3 Outposts. For more information about S3 storage classes, see Amazon S3 Storage Classes. Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see Considerations when working with S3 storage classes in DataSync. Defaults to None.
        s3_config(Dict): The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that is used to access an Amazon S3 bucket. For detailed information about using such a role, see Creating a Location for Amazon S3 in the AWS DataSync User Guide.
        agent_arns(List, optional): If you are using DataSync on an AWS Outpost, specify the Amazon Resource Names (ARNs) of the DataSync agents deployed on your Outpost. For more information about launching a DataSync agent on an AWS Outpost, see Deploy your DataSync agent on AWS Outposts. Defaults to None.
        tags(List, optional): The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.s3.create(
                ctx, s3_bucket_arn=value, s3_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.s3.create s3_bucket_arn=value, s3_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="create_location_s3",
        op_kwargs={
            "Subdirectory": subdirectory,
            "S3BucketArn": s3_bucket_arn,
            "S3StorageClass": s3_storage_class,
            "S3Config": s3_config,
            "AgentArns": agent_arns,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, location_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata, such as bucket name, about an Amazon S3 bucket location.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the Amazon S3 bucket location to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.s3.describe(ctx, location_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.s3.describe location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="describe_location_s3",
        op_kwargs={"LocationArn": location_arn},
    )
