"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    server_hostname: str,
    bucket_name: str,
    agent_arns: List,
    server_port: int = None,
    server_protocol: str = None,
    subdirectory: str = None,
    access_key: str = None,
    secret_key: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an endpoint for a self-managed object storage bucket. For more information about self-managed object storage locations, see Creating a location for object storage.

    Args:
        server_hostname(str): The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network. .
        server_port(int, optional): The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one. Defaults to None.
        server_protocol(str, optional): The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS. Defaults to None.
        subdirectory(str, optional): The subdirectory in the self-managed object storage server that is used to read data from. Defaults to None.
        bucket_name(str): The bucket on the self-managed object storage server that is used to read data from.
        access_key(str, optional): Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use AccessKey and SecretKey to provide the user name and password, respectively. Defaults to None.
        secret_key(str, optional): Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use AccessKey and SecretKey to provide the user name and password, respectively. Defaults to None.
        agent_arns(List): The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
        tags(List, optional): The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.object_storage.create(
                ctx, server_hostname=value, bucket_name=value, agent_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.object_storage.create server_hostname=value, bucket_name=value, agent_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="create_location_object_storage",
        op_kwargs={
            "ServerHostname": server_hostname,
            "ServerPort": server_port,
            "ServerProtocol": server_protocol,
            "Subdirectory": subdirectory,
            "BucketName": bucket_name,
            "AccessKey": access_key,
            "SecretKey": secret_key,
            "AgentArns": agent_arns,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, location_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata about a self-managed object storage server location. For more information about self-managed object storage locations, see Creating a location for object storage.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the self-managed object storage server location that was described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.object_storage.describe(
                ctx, location_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.object_storage.describe location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="describe_location_object_storage",
        op_kwargs={"LocationArn": location_arn},
    )


async def update(
    hub,
    ctx,
    location_arn: str,
    server_port: int = None,
    server_protocol: str = None,
    subdirectory: str = None,
    access_key: str = None,
    secret_key: str = None,
    agent_arns: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates some of the parameters of a previously created location for self-managed object storage server access. For information about creating a self-managed object storage location, see Creating a location for object storage.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.
        server_port(int, optional): The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one. Defaults to None.
        server_protocol(str, optional): The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS. Defaults to None.
        subdirectory(str, optional): The subdirectory in the self-managed object storage server that is used to read data from. Defaults to None.
        access_key(str, optional): Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use AccessKey and SecretKey to provide the user name and password, respectively. Defaults to None.
        secret_key(str, optional): Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use AccessKey and SecretKey to provide the user name and password, respectively. Defaults to None.
        agent_arns(List, optional): The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.object_storage.update(ctx, location_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.object_storage.update location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="update_location_object_storage",
        op_kwargs={
            "LocationArn": location_arn,
            "ServerPort": server_port,
            "ServerProtocol": server_protocol,
            "Subdirectory": subdirectory,
            "AccessKey": access_key,
            "SecretKey": secret_key,
            "AgentArns": agent_arns,
        },
    )
