"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub,
    ctx,
    subdirectory: str,
    server_hostname: str,
    on_prem_config: Dict,
    mount_options: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Defines a file system on a Network File System (NFS) server that can be read from or written to.

    Args:
        subdirectory(str): The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network.  To see all the paths exported by your NFS server, run "showmount -e nfs-server-name" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.  To transfer all the data in the folder you specified, DataSync needs to have permissions to read all the data. To ensure this, either configure the NFS export with no_root_squash, or ensure that the permissions for all of the files that you want DataSync allow read access for all users. Doing either enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access. If you are copying data to or from your AWS Snowcone device, see NFS Server on AWS Snowcone for more information. For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.
        server_hostname(str): The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS server. An agent that is installed on-premises uses this host name to mount the NFS server in a network.  If you are copying data to or from your AWS Snowcone device, see NFS Server on AWS Snowcone for more information.  This name must either be DNS-compliant or must be an IP version 4 (IPv4) address. .
        on_prem_config(Dict): Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server.  If you are copying data to or from your AWS Snowcone device, see NFS Server on AWS Snowcone for more information.
        mount_options(Dict, optional): The NFS mount options that DataSync can use to mount your NFS share. Defaults to None.
        tags(List, optional): The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.nf.create_multiple(
                ctx, subdirectory=value, server_hostname=value, on_prem_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.nf.create_multiple subdirectory=value, server_hostname=value, on_prem_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="create_location_nfs",
        op_kwargs={
            "Subdirectory": subdirectory,
            "ServerHostname": server_hostname,
            "OnPremConfig": on_prem_config,
            "MountOptions": mount_options,
            "Tags": tags,
        },
    )


async def describe_all(hub, ctx, location_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata, such as the path information, about an NFS location.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the NFS location to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.nf.describe_all(ctx, location_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.nf.describe_all location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="describe_location_nfs",
        op_kwargs={"LocationArn": location_arn},
    )


async def update_multiple(
    hub,
    ctx,
    location_arn: str,
    subdirectory: str = None,
    on_prem_config: Dict = None,
    mount_options: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates some of the parameters of a previously created location for Network File System (NFS) access. For information about creating an NFS location, see Creating a location for NFS.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the NFS location to update.
        subdirectory(str, optional): The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network. To see all the paths exported by your NFS server, run "showmount -e nfs-server-name" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.  To transfer all the data in the folder that you specified, DataSync must have permissions to read all the data. To ensure this, either configure the NFS export with no_root_squash, or ensure that the files you want DataSync to access have permissions that allow read access for all users. Doing either option enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access. If you are copying data to or from your AWS Snowcone device, see NFS Server on AWS Snowcone for more information. For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation. Defaults to None.
        on_prem_config(Dict, optional): A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location. Defaults to None.
        mount_options(Dict, optional): Represents the mount options that are available for DataSync to access an NFS location. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.nf.update_multiple(ctx, location_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.nf.update_multiple location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="update_location_nfs",
        op_kwargs={
            "LocationArn": location_arn,
            "Subdirectory": subdirectory,
            "OnPremConfig": on_prem_config,
            "MountOptions": mount_options,
        },
    )
