"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, location_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the configuration of a location used by AWS DataSync.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the location to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.init.delete(ctx, location_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.init.delete location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="delete_location",
        op_kwargs={"LocationArn": location_arn},
    )


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of source and destination locations. If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.

    Args:
        max_results(int, optional): The maximum number of locations to return. Defaults to None.
        next_token(str, optional): An opaque string that indicates the position at which to begin the next list of locations. Defaults to None.
        filters(List, optional): You can use API filters to narrow down the list of resources returned by ListLocations. For example, to retrieve all tasks on a specific source location, you can use ListLocations with filter name LocationType S3 and Operator Equals. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="list_locations",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
        },
    )
