"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub,
    ctx,
    fsx_filesystem_arn: str,
    security_group_arns: List,
    user: str,
    password: str,
    subdirectory: str = None,
    tags: List = None,
    domain: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an endpoint for an Amazon FSx for Windows File Server file system.

    Args:
        subdirectory(str, optional): A subdirectory in the location’s path. This subdirectory in the Amazon FSx for Windows File Server file system is used to read data from the Amazon FSx for Windows File Server source location or write data to the FSx for Windows File Server destination. Defaults to None.
        fsx_filesystem_arn(str): The Amazon Resource Name (ARN) for the FSx for Windows File Server file system.
        security_group_arns(List): The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Windows File Server file system.
        tags(List, optional): The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location. Defaults to None.
        user(str): The user who has the permissions to access files and folders in the FSx for Windows File Server file system. For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see user.
        domain(str, optional): The name of the Windows domain that the FSx for Windows File Server belongs to. Defaults to None.
        password(str): The password of the user who has the permissions to access files and folders in the FSx for Windows File Server file system.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.fsx_window.create_multiple(
                ctx, fsx_filesystem_arn=value, security_group_arns=value, user=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.fsx_window.create_multiple fsx_filesystem_arn=value, security_group_arns=value, user=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="create_location_fsx_windows",
        op_kwargs={
            "Subdirectory": subdirectory,
            "FsxFilesystemArn": fsx_filesystem_arn,
            "SecurityGroupArns": security_group_arns,
            "Tags": tags,
            "User": user,
            "Domain": domain,
            "Password": password,
        },
    )


async def describe_all(hub, ctx, location_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata, such as the path information about an Amazon FSx for Windows File Server location.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the FSx for Windows File Server location to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.fsx_window.describe_all(
                ctx, location_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.fsx_window.describe_all location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="describe_location_fsx_windows",
        op_kwargs={"LocationArn": location_arn},
    )
