"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub,
    ctx,
    efs_filesystem_arn: str,
    ec2_config: Dict,
    subdirectory: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an endpoint for an Amazon EFS file system.

    Args:
        subdirectory(str, optional): A subdirectory in the location’s path. This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination. By default, AWS DataSync uses the root directory.   Subdirectory must be specified with forward slashes. For example, /path/to/folder. . Defaults to None.
        efs_filesystem_arn(str): The Amazon Resource Name (ARN) for the Amazon EFS file system.
        ec2_config(Dict): The subnet and security group that the Amazon EFS file system uses. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified. The exact relationship between security group M (of the mount target) and security group S (which you provide for DataSync to use at this stage) is as follows:     Security group M (which you associate with the mount target) must allow inbound access for the Transmission Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections either by IP address (CIDR range) or security group.    Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to the NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP address (CIDR range) or security group. For information about security groups and mount targets, see Security Groups for Amazon EC2 Instances and Mount Targets in the Amazon EFS User Guide.   .
        tags(List, optional): The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.ef.create_multiple(
                ctx, efs_filesystem_arn=value, ec2_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.ef.create_multiple efs_filesystem_arn=value, ec2_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="create_location_efs",
        op_kwargs={
            "Subdirectory": subdirectory,
            "EfsFilesystemArn": efs_filesystem_arn,
            "Ec2Config": ec2_config,
            "Tags": tags,
        },
    )


async def describe_all(hub, ctx, location_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata, such as the path information about an Amazon EFS location.

    Args:
        location_arn(str): The Amazon Resource Name (ARN) of the EFS location to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.location.ef.describe_all(ctx, location_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.location.ef.describe_all location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="describe_location_efs",
        op_kwargs={"LocationArn": location_arn},
    )
