"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    activation_key: str,
    agent_name: str = None,
    tags: List = None,
    vpc_endpoint_id: str = None,
    subnet_arns: List = None,
    security_group_arns: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Activates an AWS DataSync agent that you have deployed on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the AWS Region that you want to activate the agent in. You activate the agent in the AWS Region where your target locations (in Amazon S3 or Amazon EFS) reside. Your tasks are created in this AWS Region. You can activate the agent in a VPC (virtual private cloud) or provide the agent access to a VPC endpoint so you can run tasks without going over the public internet. You can use an agent for more than one location. If a task uses multiple agents, all of them need to have status AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run.  Agents are automatically updated by AWS on a regular basis, using a mechanism that ensures minimal interruption to your tasks.

    Args:
        activation_key(str): Your agent activation key. You can get the activation key either by sending an HTTP GET request with redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the AWS DataSync console. The redirect URL returned in the response provides you the activation key for your agent in the query string parameter activationKey. It might also include other activation-related parameters; however, these are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent. For more information, see Activating an Agent in the AWS DataSync User Guide. .
        agent_name(str, optional): The name you configured for your agent. This value is a text reference that is used to identify the agent in the console. Defaults to None.
        tags(List, optional): The key-value pair that represents the tag that you want to associate with the agent. The value can be an empty string. This value helps you manage, filter, and search for your agents.  Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @.  . Defaults to None.
        vpc_endpoint_id(str, optional): The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the client-side VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see Creating a VPC Endpoint Service Configuration in the Amazon VPC User Guide. VPC endpoint ID looks like this: vpce-01234d5aff67890e1. Defaults to None.
        subnet_arns(List, optional): The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task. The agent that runs a task must be private. When you start a task that is associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the agent must be able to route to all these four network interfaces. Defaults to None.
        security_group_arns(List, optional): The ARNs of the security groups used to protect your data transfer task subnets. See SecurityGroupArns. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.agent.create(ctx, activation_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.agent.create activation_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="create_agent",
        op_kwargs={
            "ActivationKey": activation_key,
            "AgentName": agent_name,
            "Tags": tags,
            "VpcEndpointId": vpc_endpoint_id,
            "SubnetArns": subnet_arns,
            "SecurityGroupArns": security_group_arns,
        },
    )


async def delete(hub, ctx, agent_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an agent. To specify which agent to delete, use the Amazon Resource Name (ARN) of the agent in your request. The operation disassociates the agent from your AWS account. However, it doesn't delete the agent virtual machine (VM) from your on-premises environment.

    Args:
        agent_arn(str): The Amazon Resource Name (ARN) of the agent to delete. Use the ListAgents operation to return a list of agents for your account and AWS Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.agent.delete(ctx, agent_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.agent.delete agent_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="delete_agent",
        op_kwargs={"AgentArn": agent_arn},
    )


async def describe(hub, ctx, agent_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata such as the name, the network interfaces, and the status (that is, whether the agent is running or not) for an agent. To specify which agent to describe, use the Amazon Resource Name (ARN) of the agent in your request.

    Args:
        agent_arn(str): The Amazon Resource Name (ARN) of the agent to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.agent.describe(ctx, agent_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.agent.describe agent_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="describe_agent",
        op_kwargs={"AgentArn": agent_arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of agents owned by an AWS account in the AWS Region specified in the request. The returned list is ordered by agent Amazon Resource Name (ARN). By default, this operation returns a maximum of 100 agents. This operation supports pagination that enables you to optionally reduce the number of agents returned in a response. If you have more agents than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a marker that you can specify in your next request to fetch the next page of agents.

    Args:
        max_results(int, optional): The maximum number of agents to list. Defaults to None.
        next_token(str, optional): An opaque string that indicates the position at which to begin the next list of agents. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.agent.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.agent.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="list_agents",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, agent_arn: str, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the name of an agent.

    Args:
        agent_arn(str): The Amazon Resource Name (ARN) of the agent to update.
        name(str, optional): The name that you want to use to configure the agent. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datasync.agent.update(ctx, agent_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datasync.agent.update agent_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datasync",
        operation="update_agent",
        op_kwargs={"AgentArn": agent_arn, "Name": name},
    )
