"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    task_id: str,
    task_status: str,
    error_id: str = None,
    error_message: str = None,
    error_stack_trace: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Task runners call SetTaskStatus to notify AWS Data Pipeline that a task is completed and provide information about the final status. A task runner makes this call regardless of whether the task was sucessful. A task runner does not need to call SetTaskStatus for tasks that are canceled by the web service during a call to ReportTaskProgress.

    Args:
        task_id(str): The ID of the task assigned to the task runner. This value is provided in the response for PollForTask.
        task_status(str): If FINISHED, the task successfully completed. If FAILED, the task ended unsuccessfully. Preconditions use false.
        error_id(str, optional): If an error occurred during the task, this value specifies the error code. This value is set on the physical attempt object. It is used to display error information to the user. It should not start with string "Service_" which is reserved by the system. Defaults to None.
        error_message(str, optional): If an error occurred during the task, this value specifies a text description of the error. This value is set on the physical attempt object. It is used to display error information to the user. The web service does not parse this value. Defaults to None.
        error_stack_trace(str, optional): If an error occurred during the task, this value specifies the stack trace associated with the error. This value is set on the physical attempt object. It is used to display error information to the user. The web service does not parse this value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.task.status.set(
                ctx, task_id=value, task_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.task.status.set task_id=value, task_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="set_task_status",
        op_kwargs={
            "taskId": task_id,
            "taskStatus": task_status,
            "errorId": error_id,
            "errorMessage": error_message,
            "errorStackTrace": error_stack_trace,
        },
    )
